Option Explicit
Const scriptName = "Rounded Corners"
Const scriptVer = "1.0.0"

' Revision History

' 1.0.0 - July 26, 2002 - MJM - Inital version.



' Script properties.
Const defRoundness = 18 

' Script constants, questions, and error messages.
Const qRoundness = "Round how far?"

Const errNoSelection = "This script requires a selection of rectangles."
Const errNoActiveFlow = "Can't round corners while a text flow is active."


' Enums

' enum crClass
Const crElmRect = 1382237548

' enum crMeasurementUnits
Const crHorizontalRulerUnits = 0
Const crVerticalRulerUnits = 1




' Main

Dim errNum
errNum = 0

Dim CreatorApp
Set CreatorApp = WScript.CreateObject("Creator.Application")
'Set CreatorApp = GetObject(,"Creator.Application")

CreatorApp.Visible = True

Dim sel
If CreatorApp.Documents.Count = 0 Then
  Call MsgBox(errNoSelection, vbOkonly, scriptName)
  errNum = -1
End If

'Not sure if this is needed:
'This checks to see if there is not a text selection
If errNum = 0 Then
  On Error Resume Next
  Dim textSel
  Set textSel = CreatorApp.TextSelection
  errNum = Err.Number
  On Error GoTo 0

  If errNum = 0 Then
    Call MsgBox(errNoActiveFlow, vbOkonly, scriptName)
    errNum = -1
  Else
    errNum = 0
  End If
End If

If errNum = 0 Then
  On Error Resume Next
  Set sel = CreatorApp.Selection
  errNum = Err.Number
  On Error GoTo 0
  
  If errNum <> 0 Then
    Call MsgBox(errNoSelection, vbOkonly, scriptName)
  Elseif Sel.Count < 1 Then
    Call MsgBox(errNoSelection, vbOkonly, scriptName)
    errNum = -1
  Else
    Dim allRects, elem
    allRects = True
    For Each elem in sel
      allRects = allRects And (elem.Class = crElmRect)
    Next
    
    If (Not allRects) Then
      Call MsgBox(errNoSelection, vbOkonly, scriptName)
      errNum = -1
    End If
  End If
End If

Dim answerText, roundness
Dim continueOn
If errNum = 0 Then
  continueOn = False
 
  Do
    answerText = InputBox(qRoundness, scriptName, CreatorApp.ConvertToMeasurement(defRoundness, crHorizontalRulerUnits))
    If answerText = "" Then
      continueOn = True
      errNum = -1
    Else
      On Error Resume Next
      roundness = CDbl(answerText)
      errNum = Err.Number
      On Error GoTo 0

      If (errNum <> 0) Then
        errNum = 0
	roundness = answerText
      End If
      
      continueOn = True
    End If
  Loop Until continueOn = True
End If

' Whew!  User Interface Section Done.
If errNum = 0 Then
  Dim radius(2)
  radius(0) = roundness
  radius(1) = roundness
  sel.TopLeftRadius = radius
  sel.TopRightRadius = radius
  sel.BottomLeftRadius = radius
  sel.BottomRightRadius = radius
End If
